/*tex

Stata/MP 14.1; required packages: fre, estout, rrreg

\subsection{Selection of sample for analysis}

tex*/

texdoc stlog
use http://repec.sowi.unibe.ch/files/wp8/ASQ-ETHBE-2011.dta
// - exclude observartions who did not reach the sensitive questions intro page
// - exclude obervations that did not see the sensive questions because they 
//   did not yet have exampe and did not write a paper yet
// - exclude observations where assignment of expcond failed
// - generate language filter variable (well or very well german skills)
fre expcond
drop if expcond>=.
drop if (q17==.e & q19==.e) // one obs with valid expcond who was filtered for all items
fre expcond
qui recode expcond ///
    (1 = 1 "DQ") ///
    (4 = 2 "FRwheel") ///
    (2 = 3 "FRnumb") ///
    (5 = 4 "UQbenf") ///
    (6 = 5 "CMquest") ///
    (3 = 6 "CMnumb") ///
    , gen(expcond1)
drop expcond
rename expcond1 expcond
fre expcond
fre q4_2
gen byte language = inlist(q4_2,4,5)
fre language
fre expcond if language
gen byte nopretest = (sample!=2)
fre expcond if language & nopretest 

// Treatment variables
gen byte DQ      = expcond==1
gen byte FRwheel = expcond==2
gen byte FRnumb  = expcond==3
gen byte UQbenf  = expcond==4
gen byte CMquest  = expcond==5
gen byte CMnumb   = expcond==6
texdoc stlog close


/*tex

\subsection{Effect of level of protection}

tex*/

texdoc stlog
preserve
keep id DQ FR* UQbenf CM* language nopretest protect q14* q16* q17* q18* q19*
drop *_uq *_seed
local i 0
foreach v in q14 q16 q17 q18 q19 {
    local ++i
    rename `v' sq`i'
    rename `v'_pyes pyes`i'
    rename `v'_pno pno`i'
    rename `v'_pcm pcm`i'
}
reshape long sq pyes pno pcm, i(id) j(sqid)
fre sqid
fre protect
gen byte high = (!DQ) & protect==1 if protect!=.b
forv i=1/5 {
    gen byte DQ`i' = DQ & sqid==`i'
    foreach v in FRwheel FRnumb UQbenf CMquest CMnumb {
        gen byte `v'`i' = `v' & sqid==`i'
        qui gen byte `v'`i'high = `v' & sqid==`i' & protect==1 if protect!=.b
    }
}
foreach if in "" "if language" "if language & nopretest" {
    if "`if'"!="if language" continue // remove to compute all results
    di _n as res "/* ------------------------------------------------------ */"
    if "`if'"!="" di as res "   ==> `if'"
    rrreg sq DQ? FRwheel? FRnumb? UQbenf? CMquest? CMnumb? ///
                 FRwheel?high FRnumb?high UQbenf?high CMquest?high CMnumb?high ///
                `if', nocons vce(cluster id) pyes(pyes) pno(pno) pwarner(pcm)
    testparm FRwheel?high 
    testparm FRnumb?high 
    testparm UQbenf?high 
    testparm CMquest?high 
    testparm CMnumb?high
    testparm FRwheel?high FRnumb?high UQbenf?high CMquest?high CMnumb?high
}
restore

// Results: No effects of level of protection whatsoever.
texdoc stlog close

/*tex

\subsection{Effect of yes/no dominance (CM Number)}

tex*/

texdoc stlog
preserve
keep if CMnumb
gen byte yes1 = cond(sequence==1, 1, 0)
gen byte yes2 = cond(sequence==1, 0, 1)
gen byte yes3 = cond(sequence==1, 1, 0)
gen byte yes4 = cond(sequence==1, 0, 1)
gen byte yes5 = cond(sequence==1, 1, 0)
keep id language nopretest protect q14* q16* q17* q18* q19* yes?
drop *_uq *_seed
local i 0
foreach v in q14 q16 q17 q18 q19 {
    local ++i
    rename `v' sq`i'
    rename `v'_pyes pyes`i'
    rename `v'_pno pno`i'
    rename `v'_pcm pcm`i'
}
reshape long sq pyes pno pcm yes, i(id) j(sqid)
fre sqid
fre protect
forv i=1/5 {
    gen byte sq`i' = sqid==`i'
    gen byte sqyes`i' = sqid==`i' & yes
}
foreach if in "" "if language" "if language & nopretest" {
    if "`if'"!="if language" continue // remove to compute all results
    di _n as res "/* ------------------------------------------------------ */"
    if "`if'"!="" di as res "   ==> `if'"
    rrreg sq sq? sqyes? ///
                `if', nocons vce(cluster id) pyes(pyes) pno(pno) pwarner(pcm)
    testparm sqyes?
}
restore

// Results: prevalence seems to be higher if "yes" is the dominant random
// answer; can't think of a reasonable explanation why this should be; maybe
// there is a priming effect; note that in CM Question performs much better 
// than CM Number even though "no" is always the dominant answer
texdoc stlog close

/*tex

\subsection{Effects of respondents' evaluation}

tex*/

texdoc stlog
preserve
gen byte trust = inlist(q25_1,4,5) if inlist(q25_1,1,2,3,4,5)
gen byte risk = inlist(q25_2,4,5) if inlist(q25_2,1,2,3,4,5)
gen byte cumbersome = inlist(q26_1,4,5) if inlist(q26_1,1,2,3,4,5) & expcond!=1
gen byte correct = inlist(q26_2,4,5) if inlist(q26_2,1,2,3,4,5) & expcond!=1
gen byte tprotect = inlist(q26_3,4,5) if inlist(q26_3,1,2,3,4,5) & expcond!=1
gen byte sense = inlist(q26_4,4,5) if inlist(q26_4,1,2,3,4,5) & expcond!=1
gen byte understand = inlist(q26_5,4,5) if inlist(q26_5,1,2,3,4,5) & expcond!=1
keep id DQ FR* UQbenf CM* language nopretest q14* q16* q17* q18* q19* ///
    trust risk cumbersome correct tprotect sense understand
drop *_uq *_seed
local i 0
foreach v in q14 q16 q17 q18 q19 {
    local ++i
    rename `v' sq`i'
    rename `v'_pyes pyes`i'
    rename `v'_pno pno`i'
    rename `v'_pcm pcm`i'
}
reshape long sq pyes pno pcm, i(id) j(sqid)
fre sqid
forv i=1/5 {
    foreach v in DQ FRwheel FRnumb UQbenf CMquest CMnumb {
        gen byte `v'`i' = `v' & sqid==`i'
        foreach vv in trust risk cumbersome correct tprotect sense understand {
            qui gen byte `v'`i'`vv' = `v' & `vv' & sqid==`i' if `vv'<.
        }
    }
}
foreach if in "" "if language" "if language & nopretest" {
    if "`if'"!="if language" continue // remove to compute all results
    di _n as res "/* ------------------------------------------------------ */"
    if "`if'"!="" di as res "   ==> `if'"
    foreach v in trust risk cumbersome correct tprotect sense understand {
        di as res _n "==> `v'"
        if inlist("`v'","trust","risk") {
            local DQ "DQ?"
            local DQiv "DQ?`v'"
        }
        else {
            local DQ
            local DQiv
        }
        rrreg sq `DQ' FRwheel? FRnumb? UQbenf? CMquest? CMnumb? ///
            `DQiv' FRwheel?`v' FRnumb?`v' UQbenf?`v' CMquest?`v' CMnumb?`v' ///
            `if', nocons vce(cluster id) pyes(pyes) pno(pno) pwarner(pcm)
        if "`DQ'"!="" testparm `DQiv'
        testparm  FRwheel?`v'
        testparm  FRnumb?`v'
        testparm  UQbenf?`v'
        testparm  CMquest?`v'
        testparm  CMnumb?`v'
        testparm `DQiv' FRwheel?`v' FRnumb?`v' UQbenf?`v' CMquest?`v' CMnumb?`v'
    }
}
restore

// Results (significant effects)
//
// trust: 
// n.s. overall
// p=0.025 FRwheel
// + p=0.001 FRwheel #3
// + p=0.026 DQ #4
//
// risk: overall test insignificant
// - p=0.047 UQbenf #5
//
// cumbersome: 
// p=0.001 overall
// p<0.001 UQbenf
// + p=0.025 UQbenf #2
// + p=0.044 UQbenf #3
// + p=0.000 UQbenf #4
// + p=0.000 UQbenf #5
// + p=0.021 CMquest #1
//
// correct:
// n.s. overall
// p=0.032 UQbenf
// - p=0.040 UQbenf #1
// - p=0.047 UQbenf #2
// - p=0.052 UQbenf #3
// - p=0.018 UQbenf #5
//
// tprotect:
// n.s. overall
// + p=0.004 FRwheel #3
// - p=0.004 CMquest #3
//
// sense: 
// n.s. overall
// - p=0.003 CMnumb #5
//
// understand: 
// n.s. overall
// - p=0.036 CMquest #3
//
// Summary:
// - cumbersome has positive effect on prevalence for UQbenf
// - correct has negative effect on prevalence for UQbenf
texdoc stlog close

/*tex

\subsection{Subgroup differences}

Subgroup differences in the prevalence estimates and the effects of the 
experimental conditions are analyzed by means of interaction terms. Analyzed 
subgroups are:
\begin{itemize}
\item ETH Zurich vs. University of Bern
\item Science students vs. social science or humanities students
\item females vs. males
\end{itemize}

tex*/

texdoc stlog
gen byte ETHZ = cond(sample>=2,1,0)
lab var ETHZ "ETHZ vs. UniBE"
fre ETHZ
gen byte science = cond(inlist(q3_3cat,1,4,11,12,13,14),1, ///
                   cond(inlist(q3_3cat,2,3,5,6,7,8,15),0,.)) 
lab var science "science vs. social science and humanities"
fre science
gen byte female = cond(q3_2==1,1,0) if !missing(q3_2)
lab var female "female vs. male"
fre female
corr ETHZ science female
foreach group in ETHZ science female {
    local ints
    foreach sq in FRwheel FRnumb UQbenf CMquest CMnumb {
        qui gen `sq'x`group' = `sq'*`group'
        local ints `ints' `sq'x`group'
    }
    foreach v in q14 q16 q17 q18 q19 {
        qui rrreg `v' FRwheel FRnumb UQbenf CMquest CMnumb `group' `ints' ///
            , hc2 pyes(`v'_pyes) pno(`v'_pno) pwarner(`v'_pcm)
        est sto `group'_`v'
    }
}
foreach group in ETHZ science female {
    esttab `group'_*, replace transform(@*100 100) b(2) se nonum compress ///
        varwidth(15) title(Subgroup differences: `: var lab `group'') nonote
}
texdoc stlog close


